<?php
/*
Plugin Name: Buttons X - Analytics
Plugin URI: https://www.button.sx
Description: Analytics extension for Buttons X.
Version: 1.2
Author: Gautam Thapar
Author URI: http://gautamthapar.me/
License: Envato Split license
Text Domain: btnsx-analytics
Domain Path: /languages
*/

// Make sure we don't expose any info if called directly
if ( !defined( 'ABSPATH' ) )
	exit;

define( 'BTNSX__ANALYTICS_VERSION', '1.2' );
define( 'BTNSX__ANALYTICS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'BTNSX__ANALYTICS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );

add_action( 'plugins_loaded', 'btnsx_analytics_check_main_class' );

function btnsx_analytics_check_main_class() {
	if( class_exists( 'Btnsx' )  ) {
		add_action( 'plugins_loaded', 'btnsx_analytics_textdomain' );
		add_filter( 'btnsx_options_filter', 'btnsx_analytics_options' );
		add_filter( 'btnsx_save_data_filter', 'btnsx_analytics_data' );
		add_filter( 'btnsx_shortcode_attributes', 'btnsx_analytics_button_shortcode_attributes' );
		add_filter( 'btnsx_output_button_on_click_filter', 'btnsx_analytics_output', 10, 3 );
	} else {
		add_action( 'admin_notices', 'btnsx_analytics_dependency_notice' );
	}
}

/**
 * Load plugin textdomain
 */
function btnsx_analytics_textdomain() {
	load_plugin_textdomain( 'btnsx-analytics', false, BTNSX__ANALYTICS_PLUGIN_URL . 'languages' );
}

/**
 * Buttons X - Options Filter
 */
function btnsx_analytics_options( array $options ) {
	$meta = new Btnsx();
	global $post;
	$options[] = array(
		'icon_class'	=>	'fa fa-line-chart',
		'text'			=>	__( 'Analytics', 'btnsx-analytics' ),
		'inner_group'	=>	array(
			array(
				'text'			=>	__( 'Google', 'btnsx-analytics' ),
				'elements'		=> array(
					array(
					    'type'			=>	'checkbox',
					    'id'			=>	'btnsx_opt_analytics_google',
					    'name'			=>	'btnsx_opt_analytics_google',
					    'label'			=>	__( 'Enable', 'btnsx-analytics' ),
					    'tooltip'		=>	__( 'Enable Google analytics. You must have Google analytics enabled on your website.', 'btnsx-analytics' ),
					    'class'			=> 'btnsx-checkbox',
					    'value' 		=> $meta->meta_values( $post->ID, array( 'field' => 'btnsx_analytics', 'field2' => 'google', 'value' => '0' ) )
				    ),
				    array(
						'type'			=>	'text',
						'id'			=>	'btnsx_opt_analytics_google_tracking_variable',
						'name'			=>	'btnsx_opt_analytics_google_tracking_variable',
						'label'			=>	__( 'Tracking Variable', 'btnsx-analytics' ),
						'tooltip'		=>	__( 'If using universal tracking then most probabily the tracking variable would be <code>ga</code>. It might also be possible that you have a different tracking variable. For example: If you use the free version of Google Analytics by yoast then the tracking variable will be <code>__gaTracker</code>. You can easily check which tracking variable being used on your website (check docs).', 'btnsx-analytics' ),
						'placeholder'	=>	__( 'button', 'btnsx-analytics' ),
						'value'			=>	$meta->meta_values( $post->ID, array( 'field' => 'btnsx_analytics', 'field2' => 'google_tracking_variable', 'value' => 'ga' ) )
					),
				    array(
						'type'			=>	'text',
						'id'			=>	'btnsx_opt_analytics_google_event_category',
						'name'			=>	'btnsx_opt_analytics_google_event_category',
						'label'			=>	__( 'Event Category', 'btnsx-analytics' ),
						'tooltip'		=>	__( 'It is typically the object that was interacted with (e.g. button).', 'btnsx-analytics' ),
						'placeholder'	=>	__( 'button', 'btnsx-analytics' ),
						'value'			=>	$meta->meta_values( $post->ID, array( 'field' => 'btnsx_analytics', 'field2' => 'google_event_category' ) )
					),
					array(
						'type'			=>	'text',
						'id'			=>	'btnsx_opt_analytics_google_event_label',
						'name'			=>	'btnsx_opt_analytics_google_event_label',
						'label'			=>	__( 'Event Label', 'btnsx-analytics' ),
						'tooltip'		=>	__( 'Useful for categorizing events (e.g. cart buttons).', 'btnsx-analytics' ),
						'placeholder'	=>	__( 'main button', 'btnsx-analytics' ),
						'value'			=>	$meta->meta_values( $post->ID, array( 'field' => 'btnsx_analytics', 'field2' => 'google_event_label' ) )
					),
					array(
						'type'			=>	'text',
						'id'			=>	'btnsx_opt_analytics_google_event_value',
						'name'			=>	'btnsx_opt_analytics_google_event_value',
						'label'			=>	__( 'Event Value', 'btnsx-analytics' ),
						'tooltip'		=>	__( 'Values must be non-negative. Useful to pass counts (e.g. 4) times.', 'btnsx-analytics' ),
						'placeholder'	=>	__( '4', 'btnsx-analytics' ),
						'value'			=>	$meta->meta_values( $post->ID, array( 'field' => 'btnsx_analytics', 'field2' => 'google_event_value' ) )
					),
					// array(
					//     'type'			=>	'checkbox',
					//     'id'			=>	'btnsx_opt_analytics_google_event_noninteraction',
					//     'name'			=>	'btnsx_opt_analytics_google_event_noninteraction',
					//     'label'			=>	__( 'Do not impact bounce rate', 'btnsx-analytics' ),
					//     'tooltip'		=>	__( 'Send an event without impacting the bounce rate.', 'btnsx-analytics' ),
					//     'class'			=> 'btnsx-checkbox',
					//     'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_analytics_google_event_noninteraction', 'value' => '0' ) )
				 //    )
				)
			)
		)
	);

	return $options;
}

/**
 * Buttons X - Save Data Filter
 */
function btnsx_analytics_data( array $data ) {
	
	$data['btnsx_analytics'] = array(
		'google' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_analytics_google'] ) ? $_POST['btnsx_opt_analytics_google'] : '' ),
		'google_tracking_variable' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_analytics_google_tracking_variable'] ) ? $_POST['btnsx_opt_analytics_google_tracking_variable'] : '' ),
		'google_event_category' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_analytics_google_event_category'] ) ? $_POST['btnsx_opt_analytics_google_event_category'] : '' ),
		'google_event_label' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_analytics_google_event_label'] ) ? $_POST['btnsx_opt_analytics_google_event_label'] : '' ),
		'google_event_value' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_analytics_google_event_value'] ) ? $_POST['btnsx_opt_analytics_google_event_value'] : '' ),
	);

	return $data;
}

/**
 * Buttons X - Button Short Code Attributes
 */
function btnsx_analytics_button_shortcode_attributes( array $atts ) {
	
	$atts[] = array(
		// Google
		'analytics_google'							=>	'',
		'analytics_google_tracking_variable'		=>	'',
		'analytics_google_event_category'			=>	'',
		'analytics_google_event_label'				=>	'',
		'analytics_google_event_value'				=>	'',
		'analytics_google_event_noninteraction'		=>	'',
	);

	return $atts;
}

/**
 * Buttons X - Button Attributes Filter
 */
function btnsx_analytics_output( array $data, $options, $atts ) {
	
	extract( shortcode_atts( $options, $atts ) );
	
	$meta = get_post_meta( $id, 'btnsx', true );

	// Analytics
		if( $analytics_google === '' ){
			$analytics_google = isset( $meta['btnsx_analytics']['google'] ) ? $meta['btnsx_analytics']['google'] : '';
		}
		if( $analytics_google_event_category === '' ){
			$analytics_google_event_category = isset( $meta['btnsx_analytics']['google_event_category'] ) ? $meta['btnsx_analytics']['google_event_category'] : '';
		}
		if( $analytics_google_event_label === '' ){
			$analytics_google_event_label = isset( $meta['btnsx_analytics']['google_event_label'] ) ? $meta['btnsx_analytics']['google_event_label'] : '';
		}
		if( $analytics_google_event_value === '' ){
			$analytics_google_event_value = isset( $meta['btnsx_analytics']['google_event_value'] ) ? $meta['btnsx_analytics']['google_event_value'] : '';
		}
		if( $analytics_google_event_noninteraction === '' ){
			$analytics_google_event_noninteraction = isset( $meta['btnsx_analytics']['google_event_noninteraction'] ) ? $meta['btnsx_analytics']['google_event_noninteraction'] : '';
		}

		$ga = '';

		if( $analytics_google == '1' ) {
			// $data_ga = 'data-ga="' . $analytics_google . '"';
			// $ga = "onClick=";
			if( $analytics_google_tracking_variable != '' ) {
				$ga .= '"' . $analytics_google_tracking_variable . '(';
			} else {
				$ga .= 'ga('; // universal tracking
			}
			$ga .= "'send','event',";
			if( $analytics_google_event_category != '' ) {
				$ga .= "'". $analytics_google_event_category ."',";
			} else {
				$ga .= "'Buttons X',";
			}
			$ga .= "'Click',";
			if( $analytics_google_event_label != '' ) {
				$ga .= "'". $analytics_google_event_label ."',";
			} else {
				$ga .= "'Button ". $id ."'";
			}
			if( $analytics_google_event_value != '' ) {
				$ga .= $analytics_google_event_value;
			}
			if( $analytics_google_event_noninteraction == '1' ) {
				// $ga .= ",{'nonInteraction': 1}";
			}
			$ga .= ');';
		}
	
	$data[] = array( $ga );

	return $data;
}

/**
 * Buttons X dependency notice
 */
function btnsx_analytics_dependency_notice() {
	$class = 'update-nag';
	$url = 'https://www.button.sx';
	$message = sprintf( __( '<strong>Buttons X Analytics</strong> extension is not really useful without <strong><a target="_blank" href="%s">Buttons X</a></strong> plugin.', 'btnsx-analytics' ), $url );
    echo '<div class="' . $class . '"><p>' . $message . '</p></div>'; 
}